{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 09.09.98 - 14:26:35 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDSPObj, MMUtils, MMWave;

type
  TForm1 = class(TForm)
    SrcFile: TMMWaveFile;
    DstFile: TMMWaveFile;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ This Demo swaps the left and right channel in a wave file }

procedure TForm1.Button1Click(Sender: TObject);
type
   TChannel = record
      Left : Smallint;
      Right: Smallint;
   end;

var
   i: integer;
   nRead,nBytes: Longint;
   Buf: array[0..4095] of TChannel;

begin
   SrcFile.Wave.FileName := 'F:\TRACK14.WAV';
   SrcFile.Wave.OpenFile;

   DstFile.Wave.CreateFile('C:\TEST.WAV',SrcFile.PWaveFormat);

   Screen.Cursor := crHourglass;

   nBytes := SrcFile.Wave.DataSize;
   while (nBytes > 0) do
   begin
      nRead := Min(nBytes,sizeOf(Buf));
      nRead := SrcFile.Wave.ReadDataBytes(@Buf,nRead);

      for i := 0 to (nRead div sizeOf(TChannel))-1 do
      begin
         SwapSmall(Buf[i].Left, Buf[i].Right);
      end;

      DstFile.Wave.WriteDataBytes(@Buf,nRead);

      dec(nBytes,nRead);
   end;

   SrcFile.Wave.CloseFile;
   DstFile.Wave.CloseFile;

   Screen.Cursor := crDefault;
end;

end.
